#pragma once
/***********************************************************************************************************************
Soubor HashTable. Obsahuje definici hashovaci tabulky ktera muze uchovavat prvky typu TElement a indexovat je pomoci klice typu
TKey. Obsahuje sablonu pro vytvoreni hash tabulky pro libivolny datovy typ. Dale sablony ro hlavni hashovaci funkci
a hlavni porovnavaci funkci.Tyto funkce muzeme realizovat jako tridy s pretizenym operatorem ()
***********************************************************************************************************************/

//***********************************************************************************************************************
//Sablona pro hlavni hash funkci 
//***********************************************************************************************************************
template <class TKey> class CDefaultHashFunction
{
public:
	unsigned int operator () (TKey &Key)
	{
		return (unsigned int)Key;
	}
};
//***********************************************************************************************************************
//Verze hashovaci fce (tridy) pro retezce char*
//***********************************************************************************************************************
template <> class CDefaultHashFunction<char*>
{
public:
	unsigned int operator () (char*	str)
	{
		unsigned int hash = 0;

		while (*str)
		{
			hash = (hash << 1) + *str++;
		}
		return hash;
	}
};
//***********************************************************************************************************************
//Sablona pro hlavni porovnavaci fci, fci ktera porovna dva klice
//***********************************************************************************************************************
template <class TKey> class CDefaultCompare
{
public:
	int operator () (TKey &left, TKey &right)
	{
		if (left > right)
			return 1;
		if (left < right)
			return -1;

		return 0;
	}
};
//***********************************************************************************************************************
//Porovnavaci fce pro retezce
//***********************************************************************************************************************
template <> class CDefaultCompare<char*>
{
public:
	int operator () (char* left, char* right)
	{
		return strcmp(left, right);
	}
};

//***********************************************************************************************************************
//Sablona pro jednu polozku v hashovaci tabulce
//***********************************************************************************************************************
template <class TKey, class TElement> class CHashTableItem
{
public:
	TKey								m_Key;
	TElement							m_Element;

	CHashTableItem*						m_next;
public:
	CHashTableItem(TKey Key, TElement Element)
	{
		m_Key = Key;
		m_Element = Element;
	}
};

//***********************************************************************************************************************
//Sablona pro hashovaci tabulku
//***********************************************************************************************************************
template <class TKey, class TElement, 
		  class THashFunction = CDefaultHashFunction<TKey>, 
		  class TCompare = CDefaultCompare<TKey> > class CHashTable
{
public:

private:
	int									m_Size;								//velikost tabulky
	int									m_Count;							//soucasny pocet prvku

	THashFunction						m_HashFunction;						//hashovaci fce
	TCompare							m_Compare;							//porovnavaci fce

	CHashTableItem<TKey, TElement>**	m_Table;							//vlastni tabulka
private:
	//***********************************************************************************************************************
	//Fce pro realokaci tabulky
	//***********************************************************************************************************************
	void								Grow()
	{
		;
	}
public:
	//***********************************************************************************************************************
	//Konstruktor
	//***********************************************************************************************************************
	CHashTable(unsigned int iSize = 101)
	{
		m_Table = new CHashTableItem<TKey, TElement>*[iSize];		//vytvoreni noveho pole pro tabulku
		memset(m_Table,0,iSize * sizeof(CHashTableItem<TKey, TElement>*));	//nulovani cele alokovane pameti
		m_Count = 0;	//vynulovani poctu obsazenych pozic
		m_Size = iSize;		//nastaveni velikosti tabulky
	}
	//***********************************************************************************************************************
	//Fce pro pridani polozky
	//***********************************************************************************************************************
	bool								Put(TKey Key, TElement Element)	//pro pridani plozky
	{
		unsigned int hash = m_HashFunction(Key) % m_Size;	//vypocitani hash

		CHashTableItem<TKey, TElement>*	current = m_Table[hash];
		while (current != NULL)
		{
			if (!m_Compare(Key,current->m_Key))
				return false;
			current = current->m_next;
		}

		CHashTableItem<TKey, TElement>* newItem = new CHashTableItem<TKey, TElement>(Key,Element);

		newItem->m_next = m_Table[hash];
		m_Table[hash] = newItem;
		m_Count++;

		return true;
	}
	//***********************************************************************************************************************
	//Fce pro zjisteni zda je polozka obsazena v poli
	//***********************************************************************************************************************
	bool								Get(TKey Key, TElement* Result)	
	{
		unsigned int hash = m_HashFunction(Key) % m_Size;

		CHashTableItem<TKey, TElement>*	current = m_Table[hash];
		while (current != NULL)
		{
			if (!m_Compare(Key, current->m_Key))
			{
				*Result = current->m_Element;
				return true;
			}
			current = current->m_next;
		}

		return false;
	}
	//***********************************************************************************************************************
	//Fce pro odstraneni polozky z tabulky
	//***********************************************************************************************************************
	bool								Remove(TKey Key)
	{
		return false;
	}
};
